<?php
include("include/header.php")
?>
<!-- breadcrumbs Area Start-->
<div class="breadcrumbs-area bg-overlay-dark bg-6">
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <div class="breadcrumbs-text text-left">
                    <h2>Does Michigan Tax Your Retirement Income?</h2>
                    <div class="breadcrumbs-bar">
                        <ul class="breadcrumbs">
                            <li><a href="index.php" title="HOME">HOME</a></li>
                            <li><a href="blog.php" title="Blog">Blog</a>&nbsp; &nbsp; &nbsp; &nbsp;<span class="fw-bold fs-4 pt-3 text-dark">-</span></li>
                            <li>Does Michigan Tax Your Retirement Income?</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- breadcrumbs Area End -->
<!-- Blog Area Start -->
<div class="blog-section ptb-120 sidebar">
    <div class="container">
        <div class="row">
            <div class="col-xl-9 col-lg-8">
                <div class="blog-image">
                    <img src="img/blog/retirement.jpg" alt="What are retirement and pension benefits?" title="What are retirement and pension benefits?">
                    <span>12 July, 2023</span>
                </div>
                <div class="blog-details-text">
                    <h2>What are retirement and pension benefits?</h2>
                    <p>A popular question with Michigan Residents is: Does Michigan Tax Your Retirement Income? This is a tricky answer due to many diffferent factors discussed in this article.</p>
                    <p>Under Michigan law, retirement and pension benefits include most payments that are reported on a 1099-R for federal tax purposes. This includes defined benefit pensions, IRA distributions and most payments from defined contribution plans. Retirement and pension benefits are taxable based on date of birth (see age groups below). Regardless of date of birth, the following are not taxed:</p>
                    <ul class="list-styled">
                        <li class="text-dark">US Military pensions</li>
                        <li class="text-dark">Michigan National Guard pensions</li>
                        <li class="text-dark">Social Security</li>
                        <li class="text-dark">Railroad benefits</li>
                        <li class="text-dark">Rollovers not included in the Federal Adjusted Gross Income (AGI)</li>
                    </ul>
                    <h3>What are Qualified Distributions?</h3>
                    <p>A subtraction is allowed on the Michigan return for qualifying distributions from retirement plans. Retirement plans include private and public employer plans, and individual plans such as IRA’s. To be considered a qualified distribution for the subtraction, several requirements must be met. For employer plans, an employee must have retired under the provisions of the plan, the pension benefits must be paid from a retirement trust fund, and the payment must be made to either the employee or a surviving spouse. (Payments made to a surviving spouse are only deductible if the employee qualified for the subtraction at the time of death.)</p>
                    <p>For qualifying distributions, there may be a limitation on the amount of the exemption that can be claimed.</p>
                    <h3>What Distributions Do Not Qualify for a Subtraction?</h3>
                    <p>Certain distributions reported on form 1099-R are not retirement or pension benefits. Under Michigan law, deferred compensation is taxable. These distributions include:</p>
                    <ul class="list-styled">
                        <li class="text-dark">All distributions from 457 plans</li>
                        <li class="text-dark">Distributions from 401(k) or 403(b) plans sourced to employee contributions and the earnings from those contributions if they were not matched by the employer.</li>
                        <li class="text-dark">Early distributions under the terms of the retirement plan are always taxable regardless of the date of birth of the taxpayer. (See retirement code chart for 1099-R below.)</li>
                    </ul>
                    <p><b>NOTE:</b> When considering your pension subtraction, ‘surviving spouse’ means the deceased spouse died prior to the current tax year (e.g., when filing a 2021 return the spouse died in 2020). Deceased spouse benefits do not include benefits from a spouse who died in 2021. If you or your spouse received pension benefits from a deceased spouse, see Form 4884, Michigan Pension Schedule instructions.</p>
                    <h3>Form 1099-R Distribution Codes</h3>
                    <p>Qualification for a subtraction is a two-step process. Use the distribution chart to determine whether your retirement and/or pension benefits qualify as a subtraction (step one). Then use the appropriate age category (step two). You must meet both qualification requirements in order to be eligible for a retirement and/or pension benefits subtraction.</p>
                    <p>If you do not qualify based on the distribution chart in step one, then you do not have a qualified subtraction and step two is not applicable.</p>
                    <p>Form 1099-R reports the total retirement and pension benefits you received during the year. Please refer to box 7 on Form(s) 1099-R for the distribution code(s) that describes the condition under which the retirement or pension benefit was paid. This chart lists distribution codes and describes eligibility of benefits for subtraction based on each code. Some exceptions exist. If your distribution code is not included in the list below or if you have questions on eligibility of your benefits, please consult your tax professional.</p>
                    <h3>For joint filers, the age of the oldest spouse determines the age category.</h3>
                    <h3 class="mt-5">Recipients born before 1946:</h3>
                    <p>For 2021 you may subtract all qualifying retirement and pension benefits received from public sources, and may subtract private retirement and pension benefits up to $54,404 if single or married filing separately or up to $108,808 if married filing jointly. Private subtraction limits must be reduced by public benefits subtracted. Withholding will only be necessary on taxable pension payments (private pension payments) that exceed the pension limits stated above for recipient born before 1946.</p>
                    <ul class="list-styled">
                        <li class="text-dark">Complete Form 4884, Michigan Pension Schedule.</li>
                        <li class="text-dark">Military pensions, Michigan National Guard pensions and Railroad Retirement benefits are entered on Schedule 1, line 11. These continue to be exempt from tax. They must be reported on Schedule W Table 2, even if no Michigan tax was withheld.</li>
                        <li class="text-dark">Social Security benefits included in your adjusted gross income are entered on Schedule 1, line 14 and are exempt from tax.</li>
                        <li class="text-dark">Public pensions can include benefits received from the federal civil service, State of Michigan public retirement systems and political subdivisions of Michigan.</li>
                        <li class="text-dark">Rollovers not included in the Federal Adjusted Gross Income (AGI) will not be taxed in Michigan.</li>
                        <li class="text-dark">Subtraction for dividends, interest, and capital gains is limited to $12,127 for single filers and $24,254 for joint filers, less any subtractions for retirement benefits including US military, Michigan National Guard, and railroad retirement benefits.</li>
                    </ul>
                    <h3>Recipients born during the period January 1, 1946 through December 31, 1952:</h3>
                    <p>If the older of you or your spouse (if married filing jointly) was born during the period January 1, 1946 through December 31, 1952, and reached the age of 67, you are eligible for a deduction against all income and will no longer deduct retirement and pension benefits. Complete Schedule 1, line 23 instead of Michigan Pension Schedule, Form 4884.</p>
                    <p>The deduction is $20,000 for a return filed as single or married, filing separately, or $40,000 for a return filed as married, filing jointly. If you checked either SSA Exempt box 22C or 22G from Schedule 1, your deduction is increased by $15,000. If you checked both boxes 22C and 22G your deduction is increased by $30,000.</p>
                    <p>The standard deduction is reduced by military pay (included on Schedule 1, line 14), military and/or railroad retirement benefits (both reported on Schedule 1, line 11)</p>
                    <p>A surviving spouse who meets all of the following conditions may elect to take the larger of the retirement and pension benefits deduction based on the deceased spouse’s year of birth (deceased spouse must be the older of the two) subject to the limits available for a single filer or the survivor’s Michigan Standard Deduction:</p>
                    <ul class="list-styled">
                        <li class="text-dark">Reached the age of 67 and</li>
                        <li class="text-dark">Not remarried and</li>
                        <li class="text-dark">Claimed a subtraction for retirement and pension benefits on a return jointly filed with the decedent in the year they died.</li>
                    </ul>
                    <h3>Recipients born after 1952:</h3>
                    <p>All retirement (private and public) and pension benefits are taxable to Michigan, unless one of following applies:</p>
                    <ul class="list-styled">
                        <li class="text-dark">Taxpayers born January 1, 1953 through January 1, 1955 should not file Form 4884. Instead, taxpayers may be eligible for a Tier 3 Michigan Standard Deduction. This deduction is up to $20,000 for a return filed as single or married filing separately, or up to $40,000 for a married filing jointly return. Exemption(s) claimed on MI-1040, lines 9a and 9d, taxable Social Security benefits, military compensation (including retirement benefits), Michigan National Guard retirement benefits and railroad retirement benefits included in AGI may reduce the amount eligible to be claimed on this line.</li>
                    </ul>
                    <p>To ensure you receive your maximum deduction complete Worksheet 2 in the MI-1040 booklet for Tier 3 Michigan Standard Deduction on Schedule 1, line 24.</p>
                    <p>A surviving spouse who meets all of the following conditions may elect to the take the larger of the retirement and pension benefits deduction based on the deceased spouse’s year of birth (deceased spouse must be the older of the two) subject to the limits available for a single filer or the survivor’s Michigan Standard Deduction:</p>
                    <ul class="list-styled">
                        <li class="text-dark">Reached the age of 67 and</li>
                        <li class="text-dark">Not remarried and</li>
                        <li class="text-dark">Claimed a subtraction for retirement and pension benefits on a return jointly filed with the decedent in the year they died.</li>
                        <li class="text-dark">The older of you or your spouse (if married filing jointly) was born after January 1, 1955 but before January 2, 1960, has reached age 62 and received retirement benefits from employment exempt from Social Security. You may be eligible for a retirement and pension subtraction of $15,000. If both spouses on a joint return qualify, the maximum subtraction increases to $30,000.</li>
                        <li class="text-dark">The older of you or your spouse (if married filing jointly) was born after January 1, 1955, received retirement benefits from employment exempt from Social Security, and were retired as of January 1, 2013. You may subtract up to $35,000 in qualifying retirement and pension benefits if single or married filing separately or $55,000 if married filing a joint return. If both spouses on a joint return qualify, the maximum subtraction increases to $70,000.</li>
                    </ul>
                    <p>Nontaxable benefits:</p>
                    <ul class="list-styled">
                        <li class="text-dark">
                    </ul>
                    <ul class="list-styled">
                        <li class="text-dark">Social Security benefits included in your adjusted gross income are entered on Schedule 1, line 14 and are exempt from tax.</li>
                        <li class="text-dark">Rollovers not included in the Federal Adjusted Gross Income (AGI) will not be taxed in Michigan.</li>
                    </ul>

                    <p>Surviving Spouse:</p>
                    <p>If a surviving spouse claimed a subtraction for retirement and pension benefits on a return jointly filed with the decedent in the year they died and the surviving spouse has not remarried, then the surviving spouse may claim the retirement and pension benefits subtraction that would have applied based on the year of birth of the older of the surviving spouse or the deceased spouse. For more information, see instructions.</p>
                    <h3>2021 Pension Deduction Estimator</h3>
                    <strong>DISCLAIMER:</strong>
                    <p>This estimator provides an unofficial estimate and has no legal bearing on any future tax liability. Interactive estimators are made available to you as self-help tools for your independent use.</p>
                    <p><b>NOTE:</b> The information you provide is anonymous and will only be used for purposes of this estimation. It will not be shared, stored or used in any other way, nor can it be used to identify the individual who enters it. It will be discarded when you exit this program.</p>
                    <hr>
                    <h3>Dividends/Interest/Capital Gain Deduction</h3>
                    <p>Senior Citizens born before 1946 (or the unremarried surviving spouse for someone born before 1946 who was at least age 65 at the time of death) may subtract dividends, interest, and capital gains. The subtraction is limited to $12,127 for single filers and to $24,254 for joint filers for 2021. These limits must be reduced by any pension subtraction taken.</p>
                    <div class="like-share">
                        <span><i class="fa fa-heart-o"></i>15 Likes</span>
                        <span><i class="fa fa-share-alt"></i>40 Shares</span>
                    </div>
                </div>
                <div class="new-comment-post mt-5">
                    <h4 class="details-title">Leave a Comment</h4>
                    <form action="#" method="post">
                        <div class="comment-form">
                            <div class="row">
                                <div class="col-lg-6">
                                    <input type="text" name="name" placeholder="Your name" class="bg-white">
                                </div>
                                <div class="col-lg-6">
                                    <input type="email" name="email" placeholder="Email here" class="bg-white">
                                </div>
                            </div>
                            <textarea name="post-comment" cols="30" rows="10" placeholder="Write here" class="bg-white"></textarea>
                            <button class="default-button" type="submit" value="">Submit Comment</button>
                        </div>
                    </form>
                </div>
            </div>
            <div class="col-xl-3 col-lg-4">
                <div class="single-sidebar-widget fix">
                    <div class="sidebar-widget-title">
                        <h5>Categories</h5>
                    </div>
                    <ul class="categories">
                        <li><a href="michigan-taxes-on-casino-winnings.php.php" title="MICHIGAN TAXES ON CASINO WINNINGS">MICHIGAN TAXES ON CASINO WINNINGS</a></li>
                        <li><a href="michigan-lowers-2023-tax-rate-3-things-to-know.php" title="Michigan Lowers 2023 Tax Rate (3 Things To Know)">Michigan Lowers 2023 Tax Rate (3 Things To Know)</a></li>
                        <li><a href="michigan-residential-solar-tax-credits.php" title="Michigan Residential Solar Tax Credits">Michigan Residential Solar Tax Credits</a></li>
                        <li><a href="ac-tax-credit-2023.php" title="AC Tax Credit 2023">AC Tax Credit 2023</a></li>
                        <li><a href="48c-tax-credit-2023.php" title="48C Tax Credit 2023">48C Tax Credit 2023</a></li>
                        <li><a href="5-michigan-tax-hacks-to-save.php" title="5 Michigan Tax Hacks to Save!">5 Michigan Tax Hacks to Save!</a></li>
                        <li><a href="michigan-tax-overages.php" title="Michigan Tax Overages">Michigan Tax Overages</a></li>
                    </ul>
                </div>
                <div class="single-sidebar-widget fix">
                    <div class="sidebar-contact-info">
                        <h4>Need Any Help?</h4>
                        <p>You can fill form and contact us via call by a given number on the top.</p>
                        <a href="contact.php" class="default-button">Contact</a>
                    </div>
                </div>
                <div class="single-sidebar-widget fix">
                    <div class="sidebar-widget-title">
                        <h5>Popular Post</h5>
                    </div>
                    <div class="single-post-widget fix">
                        <div class="post-img">
                            <a href="does-michigan-tax-your-retirement-income.php"><img src="img/blog/retirement.jpg" alt="Does Michigan Tax Your Retirement Income?" title="Does Michigan Tax Your Retirement Income?"></a>
                        </div>
                        <div class="post-texts">
                            <h5><a href="does-michigan-tax-your-retirement-income.php" title="Does Michigan Tax Your Retirement Income?">Does Michigan Tax Your Retirement Income?</a></h5>
                            <div class="post-info"><span class="author">Samadh /</span><span class="post-date"> 12 July, 2023</span></div>
                        </div>
                    </div>
                    <div class="single-post-widget fix">
                        <div class="post-img">
                            <a href="michigan-lowers-2023-tax-rate-3-things-to-know.php"><img src="img/blog/tax-rate.jpg" alt="Michigan Lowers 2023 Tax Rate (3 Things To Know)" title="Michigan Lowers 2023 Tax Rate (3 Things To Know)"></a>
                        </div>
                        <div class="post-texts">
                            <h5><a href="michigan-lowers-2023-tax-rate-3-things-to-know.php" title="Michigan Lowers 2023 Tax Rate (3 Things To Know)">Michigan Lowers 2023 Tax Rate (3 Things To Know)</a></h5>
                            <div class="post-info"><span class="author">Ajit /</span><span class="post-date"> 04 July, 2023</span></div>
                        </div>
                    </div>
                    <div class="single-post-widget fix">
                        <div class="post-img">
                            <a href="michigan-residential-solar-tax-credits.php"><img src="img/blog/solar-tax.jpg" alt="Michigan Residential Solar Tax Credits" title="Michigan Residential Solar Tax Credits"></a>
                        </div>
                        <div class="post-texts">
                            <h5><a href="michigan-residential-solar-tax-credits.php" title="Michigan Residential Solar Tax Credits">Michigan Residential Solar Tax Credits</a></h5>
                            <div class="post-info"><span class="author">Abdul /</span><span class="post-date"> 29 June, 2023</span></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Blog Area End -->
<!--Start of Client area-->
<div class="client-area ptb-40 bg-light">
    <div class="container">
        <div class="client-carousel">
            <div class="col-12">
                <div class="single-client block">
                    <a href="#" class="block">
                        <span class="p-images"><img src="img/client/1.jpg" alt="Partner Logo" title="Partner Logo"></span>
                        <span class="s-images"><img src="img/client/1-hover.png" alt=""></span>
                    </a>
                </div>
            </div>
            <div class="col-12">
                <div class="single-client block">
                    <a href="#" class="block">
                        <span class="p-images"><img src="img/client/2.png" alt="Partner Logo" title="Partner Logo"></span>

                    </a>
                </div>
            </div>
            <div class="col-12">
                <div class="single-client block">
                    <a href="#" class="block">
                        <span class="p-images"><img src="img/client/3.png" alt="Partner Logo" title="Partner Logo"></span>

                    </a>
                </div>
            </div>
            <div class="col-12">
                <div class="single-client block">
                    <a href="#" class="block">
                        <span class="p-images"><img src="img/client/4.png" alt="Partner Logo" title="Partner Logo"></span>

                    </a>
                </div>
            </div>
            <div class="col-12">
                <div class="single-client block">
                    <a href="#" class="block">
                        <span class="p-images"><img src="img/client/5.png" alt="Partner Logo" title="Partner Logo"></span>

                    </a>
                </div>
            </div>
        </div>
    </div>
</div>
<!--End of Client area-->

<?php
include("include/footer.php")
?>